//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Create GENM DEPO (GET) CMP Request
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define CMP_GENM_FILE "cmp_genm_dep2.bin"
#define CMP_USER_ID   "0002"
#define CMP_SECRET    "qwerty02"
#define CMP_TRANS_ID  "XMDK1776B5R5492X"
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
//------------------------------------------------------------------------------
//      ,   ID, , TRANS_ID
// :
// 1.          CMP
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY  hExpKey=0;
 DWORD len;
 ALG_ID ai;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,NULL,CRYPT_VERIFYCONTEXT,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //     CMP/GENM
 if (!CPGenKey(hProv,CALG_CMP_KEY,0,&hExpKey)) {
   printf("CPGenKey CALG_CMP_KEY Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  OID    
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_GEN_OID,(BYTE*)CMP_GENERAL_GET_KEY,0)) {
   printf("CPSetKeyParam KP_CMP_EXP_KEY Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  TRANS_ID
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_TRANS_ID,(BYTE*)CMP_TRANS_ID,0)) {
   printf("CPSetKeyParam KP_CMP_TRANS_ID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    
 ai=CALG_SHA_160;
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_HASH_ALG,(BYTE*)&ai,0)) {
   printf("CPSetKeyParam KP_CMP_HASH_ALG Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //      
 // ai=CALG_SHA_160_HMAC;
 ai=CALG_MAC;
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_MAC_ALG,(BYTE*)&ai,0)) {
   printf("CPSetKeyParam KP_CMP_MAC_ALG Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  ID 
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_SND_KID,(BYTE*)CMP_USER_ID,0)) {
   printf("CPSetKeyParam KP_CMP_SND_KID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_SECRET,(BYTE*)CMP_SECRET,0)) {
   printf("CPSetKeyParam KP_CMP_SECRET Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 len=sizeof(WBuf);
 if (!CPExportKey(hProv,hExpKey,hExpKey,PUBLICKEYBLOB_CMP,0,WBuf,&len)) {
   printf("CPExportKey PUBLICKEYBLOB_CMP Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 writeFile(CMP_GENM_FILE,WBuf,len);
 //
 CPDestroyKey(hProv,hExpKey);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
